/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 主控/分控 页功能
*
* 修改:
*   1. 类型 : 创建
*      作者 : 陈小荟
*      时间 : 2021.05.08
*      内容 : 所有代码
************************************************************************************************/
/* global tc_tool_get_main_htmliframe */
/* global get_webui_main_document */
/* global tc_tool_get_iframe_window */
/* global tc_tool_get_iframe_pop_layer */
/* global get_webui_pop_leyer */
/* global tc_tool_judge_jump_page */
/* global tc_tool_window_load_complete */

/* exported tc_card_reset*/
/* exported tc_card_create */
/* exported tc_card_reset_issue */
/* exported tc_card_modify_backup */
/* exported tc_card_hub_backup*/
/* exported tc_card_send_and_load */
/* exported tc_card_operate_reset_port */
/* exported tc_card_operate_delete_and_add */
/* exported tc_card_operate_jump_interface */
/* exported tc_card_operate_switch */

// 指获取指定元素失败
var str_error = "获取失败";
// 指测试前步骤失败
var str_operate_error = "操作失败";
// 延迟时间：连接硬件时为3s 否则1s
var ui_card_delay = 1000;
var str_card_url = "./pages/mc_window/mc_window.html";


// 刷新
function tc_card_reset(callback) {
    tc_tool_judge_jump_page(str_card_url,"",card_reset);
    function card_reset() {
        var iframe_document = get_webui_main_document();
        var obj_reset_btn = iframe_document.getElementsByClassName("mc_btn_group_left")[0].children[0];

        if ("[object HTMLDivElement]" === Object.prototype.toString.call(obj_reset_btn)) {
            obj_reset_btn.click();
            callback(1,"刷新成功");
            return;
        }
        callback(0,str_error);
        return;
    }
}

// 创建卡
function tc_card_create(callback) {
    tc_tool_judge_jump_page(str_card_url,"",card_create);
    function card_create() {
        var iframe_document = get_webui_main_document();
        var obj_create_btn = iframe_document.getElementsByClassName("mc_btn_group_left")[0].children[1];
        var ui_card_cnt = iframe_document.getElementsByClassName("mc_card_box").length;

        if ("[object HTMLDivElement]" === Object.prototype.toString.call(obj_create_btn)) {
            obj_create_btn.click();
            if (ui_card_cnt + 1 === iframe_document.getElementsByClassName("mc_card_box").length) {
                callback(1,"创建成功");
                return;
            }
            callback(0,"创建失败");
            return;
        }
        callback(0,str_error);
        return;
    }
}

/*
* 重置网口
* 1. 若无卡先创建一张
* 2. 重置值为 [10,20,32,64]
*/
function tc_card_reset_issue(callback) {
    tc_tool_judge_jump_page(str_card_url,"",reset_issue);
    function reset_issue() {
        var iframe_document = get_webui_main_document();
        var obj_reset_issue_btn = iframe_document.getElementsByClassName("mc_btn_group_left")[0].children[2];

        if ("[object HTMLDivElement]" === Object.prototype.toString.call(obj_reset_issue_btn)) {
            // 1.
            if (!tool_create_default_card(iframe_document)) {
                callback(0,str_operate_error);
                return;
            }
            obj_reset_issue_btn.click();
            setTimeout(function () {
                iframe_document = tc_tool_get_iframe_pop_layer(iframe_document);
                if (!iframe_document) {
                    callback(0,str_error);
                    return;
                }
                tc_tool_window_load_complete(iframe_document,function () {
                    // 2.
                    var edit_list = iframe_document.getElementsByClassName("mc_edit_input");
                    var arr_reset_val = [10,20,32,64];

                    for (var index = 0; index < edit_list.length; index++) {
                        var edit_item = edit_list[index];

                        edit_item.value = arr_reset_val[index];
                        edit_item.onblur({type: "blur",target: edit_item});
                    }
                    iframe_document.getElementsByClassName("mc_btn_group_right")[0].children[0].click();
                    callback(1,"重置成功");
                    // tc_tool_get_iframe_window().layer.closeAll();
                    return;
                });
                return;
            },ui_card_delay);
            return;
        }
        callback(0,str_error);
        return;
    }
}

/*
* 修改备份
* 1. 若无卡先创建一张
* 2. 切换备份开关
*/
function tc_card_modify_backup(callback) {
    tc_tool_judge_jump_page(str_card_url,"",modify_backup);
    function modify_backup() {
        var iframe_document = get_webui_main_document();
        var obj_modify_backup_btn = iframe_document.getElementsByClassName("mc_btn_group_left")[0].children[3];

        // 跳转SEND CARD
        iframe_document.getElementsByClassName("crumb_item")[0].children[0].click();
        // 1.
        if (!tool_create_default_card(iframe_document)) {
            callback(0,str_operate_error);
            return;
        }
        obj_modify_backup_btn.click();
        setTimeout(function () {
            iframe_document = get_webui_pop_leyer();
            if (!iframe_document) {
                callback(0,str_error);
                return;
            }
            iframe_document = iframe_document.children[1].children[0].contentDocument;
            tc_tool_window_load_complete(iframe_document,function () {
                // 2.
                iframe_document.getElementById("mc_enable").getElementsByClassName("mc_checkbox_box")[0].click();
                iframe_document.getElementsByClassName("icon-btn-apply")[0].click();
                tc_tool_get_main_htmliframe().contentDocument.getElementsByClassName("layui-layer-dialog")[0].children[3].children[0].click();
                callback(1,"发送卡备份成功");
                return;
            });
            return;
        },ui_card_delay);
        return;
    }
}

function tc_card_hub_backup(callback) {
    tc_card_hub_backup_dg("icon-hardware-write",callback);
    return;
}

function tc_card_send_and_load(callback) {
    tc_card_send_and_load_dg("icon-hardware-write",callback);
    return;
}

/*
* 重置第一张卡PORT口
* 1. 若无卡先创建一张
* 2. 重置第一张卡 PORT口 [0,10,64,64]
*/
function tc_card_operate_reset_port(callback) {
    tc_tool_judge_jump_page(str_card_url,"",reset_port);
    function reset_port() {
        var iframe_document = get_webui_main_document();
        // var obj_main = tc_tool_get_main_htmliframe();

        // obj_main.contentWindow.layer.closeAll();
        //  1.
        if (!tool_create_default_card(iframe_document)) {
            callback(0,str_operate_error);
            return;
        }
        // 2.
        var reset_box = iframe_document.getElementsByClassName("mc_reset_box")[0];
        var reset_inp_list = reset_box.getElementsByClassName("mc_edit_input");
        var reset_btn = reset_box.getElementsByClassName("icon-reset")[0];
        var arr_val = ["0","10","64","64"];
        var inp_list = iframe_document.getElementsByClassName("mc_card_box")[0].getElementsByClassName("mc_edit_input");

        setTimeout(function () {
            arr_val.forEach((element,index) => {
                var inp_item = reset_inp_list[index];

                inp_item.value = element;
                inp_item.onblur({type: "blur",target: inp_item});
            });
            reset_btn.click();
            for (var index = 0; index < inp_list.length; index++) {
                if (inp_list[index].getAttribute("default_val") !== arr_val[index % 4]) {
                    callback(0,"重置失败");
                    return;
                }
            }
            callback(1,"重置成功");
        },ui_card_delay);
        return;
    }
}

/*
* 切换操作
* 1. 若卡数量少于2 增加卡数量至两张
* 2. 卡切换：点击下一张卡按钮,切换至NEXT CARD
* 3. 点击上一张卡按钮，切换至PREV CARD
* 4. 第一张卡PORT切换：切换按钮未出现，添加PORT至出现
* 5. 触发NEXT滚动
* 6. 触发PREV滚动
*/
function tc_card_operate_switch(callback) {
    tc_tool_judge_jump_page(str_card_url,"",o_switch);
    function o_switch() {
        var iframe_document = get_webui_main_document();
        var ui_card_cnt = iframe_document.getElementsByClassName("mc_card_box").length;

        // 1.
        while (2 > ui_card_cnt) {
            tc_tool_get_iframe_window().mc_clk_create_card();
            ui_card_cnt++;
        }

        // 2.
        var o_btn_box = iframe_document.getElementsByClassName("swiper_pagination_box")[0];
        var card_switch_btn = o_btn_box.getElementsByClassName("next_btn")[0];

        card_switch_btn.click();
        setTimeout (function () {
            // 3.
            card_switch_btn = o_btn_box.getElementsByClassName("prev_btn")[0];
            card_switch_btn.click();

            // 4.
            var o_port_box = iframe_document.getElementsByClassName("mc_port")[0];
            var o_port_btn = o_port_box.getElementsByClassName("mc_port_next")[0];

            while ("none" === o_port_btn.style.display) {
                iframe_document.getElementsByClassName("icon-plus")[0].click();
            }

            // 5.
            o_port_btn.onmouseover();
            setTimeout (function () {
                o_port_btn.onmouseout();
                // 6.
                o_port_box.getElementsByClassName("mc_port_prev")[0].onmouseover();
                setTimeout (function () {
                    o_port_box.getElementsByClassName("mc_port_prev")[0].onmouseout();
                },ui_card_delay);
            },ui_card_delay);
            callback(1,"切换成功");
            return;
        },ui_card_delay);
    }
}

/*
* 删除添加操作
* 1. 若无卡先创建一张
* 2. 删除第一张卡 第一个PORT
* 3. 第一张卡后 添加一个PORT
* 4. 删除第一张卡
*/
function tc_card_operate_delete_and_add(callback) {
    tc_tool_judge_jump_page(str_card_url,"",delete_operate);
    function delete_operate() {
        var iframe_document = get_webui_main_document();

        //  1.
        if (!tool_create_default_card(iframe_document)) {
            callback(0,str_operate_error);
            return;
        }
        var obj_msg = {
            str_msg: "",
            b_success: true
        };
        // 2.
        var obj_list = null;
        var operate_btn = null;
        var ui_before_len = 0;

        setTimeout(function () {
            obj_list = iframe_document.getElementsByClassName("port_btn");
            operate_btn = obj_list[0].getElementsByClassName("icon-trash")[0];
            ui_before_len = obj_list.length;
            operate_btn.click();
            obj_msg.str_msg += "删除PORT";
            tool_delete_msg(
                ui_before_len - 1,
                obj_list.length,
                obj_msg
            );
        },ui_card_delay);

        // 3.
        setTimeout(function () {
            obj_list = iframe_document.getElementsByClassName("port_btn");
            ui_before_len = obj_list.length;
            iframe_document.getElementsByClassName("icon-plus")[0].click();
            obj_msg.str_msg += "添加PORT";
            tool_delete_msg(
                ui_before_len + 1,
                obj_list.length,
                obj_msg
            );
        },ui_card_delay * 1.5);

        // 4.
        setTimeout(function () {
            obj_list = iframe_document.getElementsByClassName("card_tip");
            operate_btn = obj_list[0].getElementsByClassName("icon-trash")[0];
            ui_before_len = obj_list.length;
            operate_btn.click();
            obj_msg.str_msg += "删除卡";
            tool_delete_msg(
                ui_before_len - 1,
                obj_list.length,
                obj_msg
            );
            if (obj_msg.b_success) {
                callback(1,obj_msg.str_msg);
                return;
            }
            callback(0,obj_msg.str_msg);
        },ui_card_delay * 2);
        return;
    }
}

/*
* 界面跳转
* 1. 通过导航跳转回主控界面
* 2. 添加一张卡
* 3. 进入添加卡PORT1下子窗口 -> 选择进入分控界面
* 4. 进入添加PORT下子窗口 -> 选择进入接收卡（大屏）界面
*/
function tc_card_operate_jump_interface(callback) {
    tc_tool_judge_jump_page(str_card_url,"",jump_interface);
    function jump_interface() {
        var obj_main = tc_tool_get_main_htmliframe();
        var iframe_document = get_webui_main_document();
        var card_list = iframe_document.getElementsByClassName("mc_card_box");

        // obj_main.contentWindow.layer.closeAll();
        // 1.
        iframe_document.getElementsByClassName("crumb_item_text")[0].click();
        // 2.
        iframe_document.getElementsByClassName("mc_btn_create_card")[0].click();
        // 3.
        card_list[card_list.length - 1].getElementsByClassName("mc_port")[0].getElementsByClassName("icon-box-quick-layout")[0].click();
        setTimeout(function () {
            obj_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].children[3].children[0].click();
            setTimeout(function () {
                iframe_document.getElementsByClassName("mc_btn_create_card")[0].click();
                card_list[card_list.length - 1].getElementsByClassName("mc_port")[0].getElementsByClassName("icon-box-quick-layout")[0].click();
                // 4.
                obj_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].children[3].children[0].click();
                callback(1,"跳转成功");
                return;
            },500);
        },ui_card_delay);
        return;
    }
}


// =================================Integration==================================
/*
* 分控备份 发送/固化（-切换备份开关）
* String 按钮class
* Function 回调函数
*/
function tc_card_hub_backup_dg(str_class,callback) {
    tc_tool_judge_jump_page(str_card_url,"",hub_backup);
    function hub_backup() {
        var obj_main = tc_tool_get_main_htmliframe();
        var iframe_document = get_webui_main_document();
        var obj_hub_backup_btn = iframe_document.getElementsByClassName("mc_btn_group_right")[0].children[0];

        // obj_main.contentWindow.layer.closeAll();
        obj_hub_backup_btn.click();
        setTimeout(function () {
            iframe_document = get_webui_pop_leyer();
            if (!iframe_document) {
                callback(0,str_error);
                return;
            }
            iframe_document = iframe_document.children[1].children[0].contentDocument;
            tc_tool_window_load_complete(iframe_document,function () {
                // -
                iframe_document.getElementById("mc_enable").getElementsByClassName("mc_checkbox_box")[0].click();
                iframe_document.getElementsByClassName(str_class)[0].click();
                obj_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].children[3].children[0].click();
                setTimeout(function () {
                    if ("icon-hardware-save" === str_class) {
                        callback(1,"发送固化成功");
                    } else {
                        tc_card_hub_backup_dg("icon-hardware-save",callback);
                    }
                    return;
                },ui_card_delay);
                return;
            });
        },ui_card_delay);
        return;
    }
}

/*
* 主控分控数据 发送/固化（-若无卡先创建一张）
* String 按钮class
* Function 回调函数
*/
function tc_card_send_and_load_dg(str_class,callback) {
    tc_tool_judge_jump_page(str_card_url,"",send_or_load);
    function send_or_load() {
        var obj_main = tc_tool_get_main_htmliframe();
        var iframe_document = get_webui_main_document();
        var obj_hub_backup_btn = iframe_document.getElementsByClassName("mc_btn_group_right")[0].children[1];

        // obj_main.contentWindow.layer.closeAll();
        if ("[object HTMLDivElement]" === Object.prototype.toString.call(obj_hub_backup_btn)) {
            // -
            if (!tool_create_default_card(iframe_document)) {
                callback(0,str_operate_error);
                return;
            }

            obj_hub_backup_btn.click();
            setTimeout(function () {
                iframe_document = get_webui_pop_leyer();
                if (!iframe_document) {
                    callback(0,str_error);
                    return;
                }
                iframe_document = iframe_document.children[1].children[0].contentDocument;
                tc_tool_window_load_complete(iframe_document,function () {
                    iframe_document.getElementsByClassName(str_class)[0].click();
                    obj_main.contentDocument.getElementsByClassName("layui-layer-dialog")[0].children[3].children[0].click();
                    setTimeout(function () {
                        if ("icon-hardware-save" === str_class) {
                            callback(1,"发送固化成功");
                        } else {
                            tc_card_send_and_load_dg("icon-hardware-save",callback);
                        }
                        return;
                    },ui_card_delay);
                    return;
                });
                return;
            },ui_card_delay);
            return;
        }
        callback(0,str_error);
        return;
    }
}


// ===================================TOOL=======================================
// 当前无卡 创建一张
// Object : iframe document
function tool_create_default_card(iframe_document) {
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(iframe_document)) {
        return false;
    }
    var ui_card_cnt = iframe_document.getElementsByClassName("mc_card_box").length;

    if (0 === ui_card_cnt) {
        tc_tool_get_iframe_window().mc_clk_create_card();
        if (ui_card_cnt + 1 !== iframe_document.getElementsByClassName("mc_card_box").length) {
            return false;
        }
    }
    return true;
}

// 删除添加操作判断
function tool_delete_msg(ui_before_len,ui_after_len,obj_msg) {
    if (ui_before_len === ui_after_len) {
        obj_msg.str_msg += "成功；";
    } else {
        obj_msg.str_msg += "失败；";
        obj_msg.b_success = false;
    }
    return true;
}


